/*
  Get/set sram flag in an NES rom.

  This program is licensed under the GPL.

  June 26, 2004
    v1.0 - initial version
  */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

// O_BINARY isn't needed in Linux
#ifndef O_BINARY
#define O_BINARY 0
#endif

int main(int argc, char *argv[])
{
    unsigned char start[7];
    unsigned char flags;
    int in, out;

    if (argc == 2) {
	in = open(argv[1], O_RDONLY | O_BINARY);
	
	if (read(in, start, 7) < 7) {
           fprintf(stderr, "%s is too small\n", argv[1]);
	   return 1;
	}
	close(in);

	flags = start[6] & 15;

	if (flags & 2)
	   printf("Sram is enabled on %s.\n", argv[1]);
	else
	   printf("Sram is disabled on %s.\n", argv[1]);
	return 0;
    } else if (argc == 3) {
	in = open(argv[2], O_RDONLY | O_BINARY);
	out = open(argv[2], O_WRONLY | O_BINARY);
    
	if (read(in, start, 7) < 7) {
           fprintf(stderr, "%s is too small\n", argv[1]);
	   return 1;
	}
	close(in);

        printf("%hhx\n", start[6]);
	flags = start[6] & 15;
	if ((strcmp(argv[1], "-1") == 0) ||
	    (strcmp(argv[1], "1") == 0))
	   flags = flags | 2;
	if ((strcmp(argv[1], "-0") == 0) ||
	    (strcmp(argv[1], "0") == 0))
	   flags = flags & ~2;
	start[6] = flags | (start[6] & ~15);
        printf("%hhx\n", start[6]);
        if (write(out, start, 7) < 7) {
	  fprintf(stderr, "Write to %s failed", argv[1]);
	  return 1;
	}
	close(out);
	return 0;
    }
    
    fprintf(stderr, "Usage: %s [0|1] <file.nes>\n"
                    "\t0 to disable sram\n"
		    "\t1 to enable sram\n"
		    "\tnothing to show current status\n", argv[0]);
    return 1;
}
